/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Debuggable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class Offset implements Debuggable {
	private double modX = 0;
	private double modY = 0;
	private double modZ = 0;
	private final boolean isOffset;
	
	public Offset(final String[] args) {
		if (args.length == 3 && args[0].matches("-?([0-9]*\\.)?[0-9]+") && args[1].matches("-?([0-9]*\\.)?[0-9]+") && args[2].matches("-?([0-9]*\\.)?[0-9]+")) {
			modX = Double.parseDouble(args[0]);
			modY = Double.parseDouble(args[1]);
			modZ = Double.parseDouble(args[2]);
		} else {
			for (final String arg : args) {
				boolean ok = true;
				final BlockFace f = Utils.getBlockFace(arg.replaceFirst("^[0-9.]+ ?", ""), false);
				if (f != null) {
					try {
						final double a = Double.parseDouble(arg.replaceFirst("[^0-9.].*$", ""));
						modX += f.getModX() * a;
						modY += f.getModY() * a;
						modZ += f.getModZ() * a;
					} catch (final NumberFormatException e) {
						ok = false;
					}
				} else {
					ok = false;
				}
				if (!ok) {
					Skript.error("'" + arg + "' is not an offset", true);
					isOffset = false;
					return;
				}
			}
		}
		isOffset = modX != 0 || modY != 0 || modZ != 0;
	}
	
	public Block setOff(final Block block) {
		if (block == null || !isOffset)
			return block;
		return block.getRelative((int) Math.round(modX), (int) Math.round(modY), (int) Math.round(modZ));
	}
	
	public Location setOff(final Location location) {
		if (location == null || !isOffset)
			return location;
		return new Location(location.getWorld(), location.getX() + modX, location.getY() + modY, location.getZ() + modZ);
	}
	
	public boolean isOffset() {
		return isOffset;
	}
	
	/**
	 * @return "dx,dy,dz"
	 */
	@Override
	public String getDebugMessage() {
		return "" + modX + "," + modY + "," + modZ;
	}
	
	@Override
	public int hashCode() {
		return (int) (modX + 2 * modY + 4 * modZ);
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (obj == this)
			return true;
		if (!(obj instanceof Offset))
			return false;
		final Offset other = (Offset) obj;
		if (!isOffset && !other.isOffset)
			return true;
		return (Math.abs(modX - other.modX) < 0.0001 && Math.abs(modY - other.modY) < 0.0001 && Math.abs(modZ - other.modZ) < 0.0001);
	}
	
}
