/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;

public class ItemType {
	
	public ArrayList<ItemData> types = new ArrayList<ItemData>();
	
	private ItemType item = null;
	private ItemType block = null;
	
	public ItemType() {}
	
	public ItemType(final ItemData... types) {
		for (final ItemData type : types) {
			this.types.add(type);
		}
	}
	
	public ItemType(final ItemStack i) {
		types.add(new ItemData(i));
	}
	
	public ItemType(final Block block) {
		final ItemData d = new ItemData();
		d.typeid = block.getTypeId();
		d.dataMin = d.dataMax = block.getData();
		types.add(d);
	}
	
	public void setItem(ItemType item) {
		this.item = item;
	}
	public void setBlock(ItemType block) {
		this.block = block;
	}
	
	public ItemType getItem() {
		return item == null ? this : item;
	}
	public ItemType getBlock() {
		return block == null ? this : block;
	}
	
	public boolean isOfType(final ItemStack item) {
		for (final ItemData type : types) {
			if (type.isOfType(item))
				return true;
		}
		return false;
	}
	
	public boolean isOfType(final Block block) {
		for (final ItemData d : types) {
			if ((d.typeid == -1 || block.getTypeId() == d.typeid) && (d.dataMin == -1 || block.getData() >= d.dataMin) && (d.dataMax == -1 || block.getData() <= d.dataMax))
				return true;
		}
		return false;
	}
	
	/**
	 * @return "itemdata, ..."
	 */
	@Override
	public String toString() {
		return Utils.join(types);
	}
	
	public boolean setBlock(final Block block, final boolean applyPhysics) {
		ItemType b = getBlock();
		ItemData d;
		boolean[] tried = new boolean[b.types.size()];
		while (true) {
			int i = Skript.random.nextInt(types.size());
			if ((d = b.types.get(i)).typeid < 256)
				break;
			for (boolean t:tried) {
				if (!t)
					continue;
			}
			return false;
		}
		if (d.typeid != -1)
			block.setTypeId(d.typeid, applyPhysics && d.dataMin == -1 && d.dataMax == -1);
		else
			block.setTypeId(Skript.random.nextInt(256), applyPhysics && d.dataMin == -1 && d.dataMax == -1);
		if (d.dataMin != -1 || d.dataMax != -1) {
			block.setData((byte) d.getData(), applyPhysics);
		}
		return true;
	}
	
	/**
	 * intersects all ItemDatas with all ItemDatas of the given ItemType, returning an ItemType with n*m ItemDatas, where n = #ItemDatas of this ItemType, and m = #ItemDatas of the
	 * argument.
	 * 
	 * more info: {@link ItemData#intersection(ItemData)}
	 * 
	 * @param other
	 * @return
	 */
	public ItemType intersection(final ItemType other) {
		final ItemType r = new ItemType();
		for (final ItemData d1 : types) {
			for (final ItemData d2 : other.types) {
				r.types.add(d1.intersection(d2));
			}
		}
		return r;
	}
	
	/**
	 * 
	 * @return a random ItemStack of this type.
	 */
	public ItemStack getRandom() {
		return Utils.getRandom(getItem().types).getRandom();
	}
	
	public Iterator<ItemStack> getAll() {
		return new Iterator<ItemStack>() {
			
			ListIterator<ItemData> iter = types.listIterator();
			Iterator<ItemStack> currentDataIter;
			
			@Override
			public boolean hasNext() {
				return iter.hasNext() || currentDataIter.hasNext();
			}
			
			@Override
			public ItemStack next() {
				if (currentDataIter == null || !currentDataIter.hasNext()) {
					currentDataIter = iter.next().getAll();
				}
				return currentDataIter.next();
			}
			
			@Override
			public void remove() {}
			
		};
	}
	
}
