/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.loops;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.BlockSphereIterator;

/**
 * @author Peter Gttinger
 * 
 */
public class LoopVarBlock extends LoopVar<Block> {
	
	static {
		Skript.addLoop(LoopVarBlock.class, Block.class, "block", "blocks in radius %float%( around %location%)?");
	}
	
	private Variable<Float> radii;
	private Variable<Location> centers;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		radii = (Variable<Float>) vars.get(0);
		centers = (Variable<Location>) vars.get(1);
	}
	
	@Override
	protected Iterator<Block> iterator(final Event e) {
		return new BlockSphereIterator(centers.get(e)[0], radii.get(e)[0]);
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		final ItemStack is = Skript.convert(to[0], ItemStack.class);
		if (is == null)
			return;
		current().setTypeIdAndData(is.getTypeId(), is.getData().getData(), true);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {
		current().setTypeId(0);
	}
	
}
