/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.loops;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.util.ObjectIterator;

/**
 * @author Peter Gttinger
 *
 */
public class LoopVarArguments extends LoopVar<Object> {

	static {
		Skript.addLoop(LoopVarArguments.class, Object.class, "argument", "arguments", "arguments as (.+)");
	}
	
	private Class<?> r = null;
	
	@Override
	public void init(List<Variable<?>> vars, int matchedPattern, Matcher matcher) {
		if (matchedPattern != 0) {
			r = Skript.getClassFromUserInput(matcher.group(1));
			if (r == null) {
				Skript.error("'"+ matcher.group(1) + "' is not a known type", true);
			}
		}
	}

	@Override
	protected Iterator<Object> iterator(Event e) {
		String s;
		if (e instanceof PlayerCommandPreprocessEvent) {
			s = ((PlayerCommandPreprocessEvent) e).getMessage();
		} else if (e instanceof ServerCommandEvent) {
			s = ((ServerCommandEvent) e).getCommand();
		} else {
			return null;
		}
		if (r == null) {
			return new ObjectIterator(Arrays.asList(s.split(" ")).iterator());
		}
		return new ObjectIterator(Arrays.asList(Expressions.parseDataArray(s, r)).iterator());
	}

	@Override
	public void set(Event e, Object[] to) {}

	@Override
	public void add(Event e, Object[] add) {}

	@Override
	public void remove(Event e, Object[] rem) {}

	@Override
	public void clear(Event e) {}
	
}
