/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Getter;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class ScheduledEvent extends Event {
	private static final long serialVersionUID = 1525399604414861656L;
	
	static {
		Skript.addEventValue(ScheduledEvent.class, World.class, new Getter<World, ScheduledEvent>() {
			@Override
			public World get(final ScheduledEvent e) {
				return e.getWorld();
			}
		});
	}
	
	private static final HandlerList handlers = new HandlerList();
	
	transient private World world;
	private final EvtPeriodical event;
	
	protected ScheduledEvent(final World world, final EvtPeriodical event) {
		super("scheduled");
		this.world = world;
		this.event = event;
	}
	
	public final World getWorld() {
		return world;
	}
	
	final EvtPeriodical getSkriptEvent() {
		return event;
	}
	
	@Override
	public HandlerList getHandlers() {
		return handlers;
	}
	
	public static HandlerList getHandlerList() {
		return handlers;
	}
}
