/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
public class EvtItem extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtItem.class, BlockDispenseEvent.class, "dispense(( of)? %itemtype%)?");
		Skript.addEvent(EvtItem.class, ItemSpawnEvent.class, "item spawn(( of)? %itemtype%)?");
		Skript.addEvent(EvtItem.class, PlayerDropItemEvent.class, "drop(( of)? %itemtype%)?");
		Skript.addEvent(EvtItem.class, PlayerEggThrowEvent.class, "throw(( of)? %itemtype%)?");
	}
	
	private ItemType[] types;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		types = (ItemType[]) args[0];
	}
	
	@Override
	public boolean check(final Event e) {
		if (types == null)
			return true;
		final ItemStack is = Skript.getEventValue(e, ItemStack.class);
		for (final ItemType type : types) {
			if (type.isOfType(is))
				return true;
		}
		return false;
	}
	
}
