/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;

@SuppressWarnings("unchecked")
public class EvtCommand extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtCommand.class, Skript.array(PlayerCommandPreprocessEvent.class, ServerCommandEvent.class), "commands? %string%");
	}
	
	private String[] commands;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		commands = (String[]) args[0];
	}
	
	@Override
	public boolean check(final Event e) {
		if (e instanceof PlayerCommandPreprocessEvent) {
			for (final String command : commands) {
				if (((PlayerCommandPreprocessEvent) e).getMessage().split(" ", 2)[0].equalsIgnoreCase(command))
					return true;
			}
		} else if (e instanceof ServerCommandEvent) {
			for (final String command : commands) {
				if (((ServerCommandEvent) e).getCommand().split(" ", 2)[0].equalsIgnoreCase(command))
					return true;
			}
		}
		return false;
	}
	
}
