/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
@SuppressWarnings("unchecked")
public class EvtBlock extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtBlock.class, Skript.array(BlockBreakEvent.class, PaintingBreakEvent.class), "break(ing)?(( of)? %itemtype%)?");
		Skript.addEvent(EvtBlock.class, BlockBurnEvent.class, "burn(ing)?(( of)? %itemtype%)?");
		Skript.addEvent(EvtBlock.class, Skript.array(BlockPlaceEvent.class, PaintingPlaceEvent.class), "place(( of)? %itemtype%)?");
	}
	
	private ItemType[] types;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		types = (ItemType[]) args[0];
	}
	
	@Override
	public boolean check(final Event e) {
		if (types == null)
			return true;
		final Block b = Skript.getEventValue(e, Block.class);
		if (b == null)
			return false;
		for (final ItemType type : types) {
			if (type.isOfType(b))
				return true;
		}
		return false;
	}
	
}
