package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;

public class EffTree extends Effect {
	
	static {
		Skript.addEffect(EffTree.class, "(grow|create|generate) tree(of type %treetype%)?( at %block%)?", "(grow|create|generate) %treetype% tree( at %block%)?");
	}
	
	Variable<Block> blocks;
	Variable<TreeType> types;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		types = (Variable<TreeType>) vars.get(0);
		blocks = (Variable<Block>) vars.get(1);
	}
	
	@Override
	public void execute(final Event e) {
		for (final Block b : blocks.get(e)) {
			for (final TreeType type : types.get(e)) {
				b.getWorld().generateTree(b.getLocation(), type);
			}
		}
	}
	
}
