/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Location;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.EntityType;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffSpawn extends Effect {
	
	static {
		Skript.addEffect(EffSpawn.class, "spawn %entitytype%( at %location%)?");
	}
	
	private Variable<Location> locations;
	private Variable<EntityType> types;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		types = (Variable<EntityType>) vars.get(0);
		locations = (Variable<Location>) vars.get(1);
	}
	
	@Override
	public void execute(final Event e) {
		for (final Location l : locations.get(e)) {
			for (final EntityType type : types.get(e)) {
				for (int i = 0; i < type.amount; i++)
					l.getWorld().spawn(l, type.c);
			}
		}
	}
	
}
