/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffRemove extends Effect {
	
	static {
		Skript.addEffect(EffRemove.class, "remove %object%( from %object%)?");
	}
	
	private Variable<?> what;
	private Variable<?> from;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		what = vars.get(0);
		from = vars.get(1);
	}
	
	@Override
	public void execute(final Event e) {
		from.remove(e, what.get(e));
	}
	
}
