/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.VariableString;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffMessage extends Effect {
	
	static {
		Skript.addEffect(EffMessage.class, "(message|send) %variablestring%( to %player%)?");
	}
	
	private Variable<VariableString> messages;
	private Variable<Player> recipients;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		messages = (Variable<VariableString>) vars.get(0);
		recipients = (Variable<Player>) vars.get(1);
	}
	
	@Override
	protected void execute(final Event e) {
		for (final VariableString messageVS : messages.get(e)) {
			final String message = messageVS.get(e);
			if (message == null)
				continue;
			for (final Player p : recipients.get(e)) {
				p.sendMessage(message);
			}
		}
	}
}
