/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.Trigger;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Loop;
import ch.njol.skript.api.TriggerItem;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class EffExit extends Effect {
	
	static {
		Skript.addEffect(EffExit.class, "(exit|stop)", "(exit|stop) (1 )?loop", "(exit|stop) (\\d+) loops", "(exit|stop) all loops");
	}
	
	private int breakLevels;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		switch (matchedPattern) {
			case 0:
				breakLevels = TriggerFileLoader.currentLoops.size() + 1;
			break;
			case 1:
				breakLevels = 1;
			break;
			case 2:
				breakLevels = Integer.parseInt(matcher.group(2));
				if (breakLevels > TriggerFileLoader.currentLoops.size()) {
					if (TriggerFileLoader.currentLoops.isEmpty())
						Skript.error("You can't " + matcher.group(1) + " any loops because there are no loops present");
					else
						Skript.error("You can't " + matcher.group() + " because there are only " + TriggerFileLoader.currentLoops.size() + " loops present");
					breakLevels = TriggerFileLoader.currentLoops.size();
					return;
				}
			break;
			case 3:
				breakLevels = TriggerFileLoader.currentLoops.size();
			break;
		}
	}
	
	@Override
	protected void execute(final Event e) {
		int i = breakLevels;
		TriggerItem item = this;
		while (i > 0) {
			item = item.getParent();
			if (item instanceof Loop) {
				((Loop) item).stop();
			} else if (item instanceof Trigger) {
				((Trigger) item).stop();
			} else {
				throw new RuntimeException("parent of invalid type");
			}
			i--;
		}
	}
	
}
