/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffDamage extends Effect {
	
	static {
		Skript.addEffect(EffDamage.class, "damage %object% by %integer%", "heal %livingentity% by %integer%", "repair %itemstack% by %integer%");// ItemStack / LivingEntity
	}
	
	private Variable<Object> damageables;
	private Variable<Integer> damages;
	private boolean heal = false;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		damageables = (Variable<Object>) vars.get(0);
		damages = (Variable<Integer>) vars.get(1);
		heal = (matchedPattern == 0);
	}
	
	@Override
	public void execute(final Event e) {
		for (final Object damageable : damageables.get(e)) {
			for (final Integer damage : damages.get(e)) {
				if (damageable instanceof ItemStack) {
					((ItemStack) damageable).setDurability((short) (((ItemStack) damageable).getDurability() + (heal ? -damage.shortValue() : damage.shortValue())));// "+" fr
																																										// Schaden,
																																										// "-" zum
																																										// Reparieren
				} else if (damageable instanceof LivingEntity) {
					((LivingEntity) damageable).damage(heal ? -damage : damage);
				}
			}
		}
	}
	
}
