/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.VariableString;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffCommand extends Effect {
	
	static {
		Skript.addEffect(EffCommand.class, "(execute )?(%commandsender% )?command %variablestring%", "(execute )?command %variablestring% by %commandsender%",
				"(let|make) %commandsender% execute( command)? %variablestring%");
	}
	
	private Variable<CommandSender> senders;
	private Variable<VariableString> commands;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (vars.get(0) instanceof CommandSender) {
			senders = (Variable<CommandSender>) vars.get(0);
			commands = (Variable<VariableString>) vars.get(1);
		} else {
			senders = (Variable<CommandSender>) vars.get(1);
			commands = (Variable<VariableString>) vars.get(0);
		}
	}
	
	@Override
	public void execute(final Event e) {
		for (final VariableString commandVS : commands.get(e)) {
			final String command = commandVS.get(e);
			for (final CommandSender sender : senders.get(e)) {
				Bukkit.getServer().dispatchCommand(sender, command);
			}
		}
	}
	
}
