/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.VariableString;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffBroadcast extends Effect {
	
	static {
		Skript.addEffect(EffBroadcast.class, "broadcast %variablestring%( (to|in) %world%)?");
	}
	
	private Variable<VariableString> messages;
	private Variable<World> worlds;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		messages = (Variable<VariableString>) vars.get(0);
		worlds = (Variable<World>) vars.get(1);
	}
	
	@Override
	public void execute(final Event e) {
		for (final VariableString mVS : messages.get(e)) {
			String m = mVS.get(e);
			if (m == null)
				continue;
			for (final World w : worlds.get(e)) {
				for (final Player p : w.getPlayers()) {
					p.sendMessage(m);
				}
			}
		}
	}
	
}
