/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.data;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.ContainerBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
public class DefaultConverters {
	
	public DefaultConverters() {}
	
	static {
		
		// Player - PlayerInventory
		Skript.addConverter(Player.class, PlayerInventory.class, new Converter<Player, PlayerInventory>() {
			@Override
			public PlayerInventory convert(final Player p) {
				return p.getInventory();
			}
		});
		Skript.addConverter(PlayerInventory.class, Player.class, new Converter<PlayerInventory, Player>() {
			@Override
			public Player convert(final PlayerInventory i) {
				for (final Player p : Bukkit.getOnlinePlayers()) {
					if (p.getInventory() == i)
						return p;
				}
				return null;
			}
		});
		
		// Block - Inventory
		Skript.addConverter(Block.class, Inventory.class, new Converter<Block, Inventory>() {
			@Override
			public Inventory convert(final Block b) {
				if (b.getState() instanceof ContainerBlock)
					return ((ContainerBlock) b).getInventory();
				return null;
			}
		});
		
		// Location - Block
		Skript.addConverter(Location.class, Block.class, new Converter<Location, Block>() {
			@Override
			public Block convert(final Location l) {
				return l.getBlock();
			}
		});
		Skript.addConverter(Block.class, Location.class, new Converter<Block, Location>() {
			@Override
			public Location convert(final Block b) {
				return b.getLocation().add(0.5, 0.5, 0.5);
			}
		});
		
		// Entity - Location
		Skript.addConverter(Entity.class, Location.class, new Converter<Entity, Location>() {
			@Override
			public Location convert(final Entity e) {
				return e.getLocation();
			}
		});
		
		// ItemType - ItemStack
		Skript.addConverter(ItemType.class, ItemStack.class, new Converter<ItemType, ItemStack>() {
			@Override
			public ItemStack convert(final ItemType i) {
				return i.getRandom();
			}
		});
		Skript.addConverter(ItemStack.class, ItemType.class, new Converter<ItemStack, ItemType>() {
			@Override
			public ItemType convert(final ItemStack i) {
				return new ItemType(i);
			}
		});
		
	}
}
