/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.config;

import java.io.PrintWriter;

/**
 * 
 * an empty line, usually a comment.<br/>
 * the subclass {@link InvalidNode} is for invalid non-empty nodes, i.e. where a parsing error ocurred.
 * 
 * @author unicode21B9
 * 
 */
public class VoidNode extends ConfigNode {
	
	VoidNode(final GroupNode parent) {
		super(null, parent);
	}
	
	@Override
	public boolean setValue(final String v) {
		orig = v;
		return true;
	}
	
	@Override
	void save(final PrintWriter w) {
		w.println(orig);
	}
}
