/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.config;

import java.io.PrintWriter;

public class ParseOptionNode extends ConfigNode {
	
	ParseOptionNode(final String name, final GroupNode parent) {
		super(name, parent);
	}
	
	@Override
	void save(final PrintWriter w) {
		final String option = orig.substring(getOrig().indexOf('[') + 1, orig.indexOf(']'));
		w.println(getIndentation() + orig.trim());
		if (orig.startsWith("!indentation[")) {
			setIndentation(option);
		} else if (orig.startsWith("!separator[")) {
			config.separator = option;
		}
		modified = false;
	}
	
}
