/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.config;

import java.io.PrintWriter;

public class EntryNode extends ConfigNode {
	
	private String value;
	
	public EntryNode(final String key, final String value, final GroupNode parent) {
		super(key, parent);
		this.value = value;
	}
	
	public String getKey() {
		return name;
	}
	
	public String getValue() {
		return value;
	}
	
	@Override
	public boolean setValue(final String v) {
		value = v;
		modified();
		return true;
	}
	
	@Override
	void save(final PrintWriter w) {
		if (!modified) {
			w.println(getIndentation() + orig);
			return;
		}
		w.append(getIndentation() + name + config.separator + value + getComment());
		modified = false;
	}
	
}
