/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ConfigReader extends BufferedReader {
	
	private String line, lastLine;
	private boolean reset = false;
	private int ln = 0;
	
	public ConfigReader(final File file) throws FileNotFoundException, UnsupportedEncodingException {
		super(new FileReader(file));
	}
	
	@Override
	public String readLine() throws IOException {
		if (reset) {
			reset = false;
			return lastLine;
		}
		lastLine = line;
		line = super.readLine();
		if (line != null && line.startsWith("﻿")) {// UTF-8 BOM - wtf Java???
			line = line.substring(3);
		}
		ln++;
		return line;
	}
	
	@Override
	public void reset() throws IOException {
		if (reset)
			throw new RuntimeException("reset was called twice without a readLine inbetween");
		reset = true;
	}
	
	public int getLineNum() {
		return ln;
	}
	
	public String getLine() {
		return line;
	}
}
