/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.config;

import java.util.Iterator;
import java.util.ListIterator;

import ch.njol.skript.SkriptLogger;

public class ConfigNodeIterator implements Iterator<ConfigNode> {
	
	private final ConfigNode parent;
	private final ListIterator<ConfigNode> iter;
	private final boolean includeVoid;
	
	public ConfigNodeIterator(final GroupNode parent, final boolean includeVoid) {
		this.parent = parent;
		iter = parent.getNodeList().listIterator();
		this.includeVoid = includeVoid;
	}
	
	@Override
	public boolean hasNext() {
		if (includeVoid) {
			if (!iter.hasNext()) {
				SkriptLogger.setNode(parent.getParent() != null ? parent : null);
				return false;
			}
			return true;
		}
		while (iter.hasNext()) {
			if (!next().isVoid()) {
				iter.previous();
				return true;
			}
		}
		SkriptLogger.setNode(parent.getParent() != null ? parent : null);
		return false;
	}
	
	@Override
	public ConfigNode next() {
		ConfigNode n;
		if (!includeVoid) {
			do {
				n = iter.next();
			} while (n.isVoid());
		} else {
			n = iter.next();
		}
		SkriptLogger.setNode(n);
		return n;
	}
	
	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
	
}
