/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import ch.njol.skript.Skript;

public class Config {
	
	File file;
	final ConfigReader r;
	
	boolean simple = false;
	String indentation;
	String indentationName;
	String separator;
	
	private void resetParseOptions() {
		indentation = "\t";
		indentationName = "tab";
		separator = "=";
	}
	
	String line = "";
	
	int level = 0;
	
	private final GroupNode main;
	
	boolean modified = false;
	int errors = 0;
	
	public Config(final File file, final boolean simple) throws IOException {
		
		this.file = file;
		this.simple = simple;
		
		if (file.length() == 0) {
			main = new GroupNode(this);
			r = null;
			Skript.warning("'" + getFileName() + "' is empty");
			return;
		}
		
		if (Skript.logVeryHigh())
			Skript.info("loading '" + file.getName() + "'");
		
		r = new ConfigReader(file);
		
		resetParseOptions();
		
		main = GroupNode.load(this);
		
		r.close();
	}
	
	public GroupNode getMainNode() {
		return main;
	}
	
	public String getFileName() {
		return file.getName();
	}
	
	public synchronized void save() throws IOException {
		if (!modified)
			return;
		resetParseOptions();
		file.createNewFile();
		final PrintWriter w = new PrintWriter(new FileWriter(file));
		main.save(w);
		w.flush();
		w.close();
		modified = false;
	}
	
	public boolean isEnabled() {
		return !file.getName().startsWith("-");
	}
	
	public boolean setEnabled(final boolean b) {
		if (isEnabled() == b) {
			return false;
		}
		return file.renameTo(new File(file, b ? file.getName().substring(1) : "-" + file.getName()));
	}
	
	public File getFile() {
		return file;
	}
}
