/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Checker;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class CondPermission extends Condition {
	
	static {
		Skript.addCondition(CondPermission.class,
				"(%player% )?ha(s|ve) (the )?permissions? %variablestring%",
				"(%player% )?(doesn't|don't|does not|do not) have (the )?permissions? %variablestring%");
	}
	
	private Variable<VariableString> permissions;
	private Variable<Player> players;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		players = (Variable<Player>) vars.get(0);
		permissions = (Variable<VariableString>) vars.get(1);
	}
	
	@Override
	public boolean run(final Event e) {
		return players.check(e, new Checker<Player>() {
			@Override
			public boolean check(final Player p) {
				return permissions.check(e, new Checker<VariableString>() {
					@Override
					public boolean check(final VariableString perm) {
						return p.hasPermission(perm.get(e));
					}
				}, getInverted());
			}
		}, getInverted());
	}
	
}
