/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class CondItemInHand extends Condition {
	
	static {
		Skript.addCondition(CondItemInHand.class,
				"(%player% )?ha(s|ve) %itemtype% in hand",
				"(%player% )?(is|are) holding %itemtype%",
				"(%player% )?(ha(s|ve) not|do(es)?n't have) %itemtype% in hand",
				"(%player% )?(is not|isn't) holding %itemtype%");
	}
	
	private Variable<Player> players;
	private Variable<ItemType> types;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		players = (Variable<Player>) vars.get(0);
		types = (Variable<ItemType>) vars.get(1);
	}
	
	@Override
	public boolean run(final Event e) {
		return players.check(e, new Checker<Player>() {
			@Override
			public boolean check(final Player p) {
				return types.check(e, new Checker<ItemType>() {
					@Override
					public boolean check(final ItemType type) {
						return type.isOfType(p.getItemInHand());
					}
				}, getInverted());
			}
		}, getInverted());
	}
	
}
