/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Comparator.Relation;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class CondIs extends Condition {
	
	static {
		Skript.addCondition(CondIs.class,
				"%object% ((is|are) (greater|more|higher) than|>=) &object%",
				"%object% ((is|are) (less|smaller) than|<=) &object%",
				"%object% ((is|are) not|!=) &object%",
				"%object% (is|are|=) %object%");
	}
	
	Variable<?> first, second;
	Relation relation;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		first = vars.get(0);
		second = vars.get(1);
		relation = Relation.values()[(matchedPattern + 1) % 4];
	}
	
	@Override
	public boolean run(final Event e) {
		final Object o1 = first.get(e);
		final Object o2 = second.get(e);
		return Skript.compare(o1, o2) == relation;
	}
	
}
