/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class CondInventoryContains extends Condition {
	
	static {
		Skript.addCondition(CondInventoryContains.class,
				"(%inventory% )?ha(s|ve) %itemtype%( in inventory)?",
				"(%inventory% )?contains? %itemtype%",
				"(%inventory% )?(ha(s|ve) not|do(es)?n't have) %itemtype%( in inventory)?",
				"(%inventory% )? do(es)?n't contain %itemtype%");
	}
	
	private Variable<Inventory> invis;
	private Variable<ItemType> items;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		invis = (Variable<Inventory>) vars.get(0);
		items = (Variable<ItemType>) vars.get(1);
		setInverted(matchedPattern >= 2);
	}
	
	@Override
	public boolean run(final Event e) {
		return invis.check(e, new Checker<Inventory>() {
			@Override
			public boolean check(final Inventory invi) {
				return items.check(e, new Checker<ItemType>() {
					@Override
					public boolean check(final ItemType types) {
						for (final ItemStack is : invi.getContents()) {
							if (types.isOfType(is))
								return true;
						}
						return false;
					}
				}, getInverted());
			}
		}, getInverted());
	}
	
}
