/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

/**
 * 
 * @author Peter Gttinger
 * 
 * @param <T> the type of this parser
 */
public interface Parser<T> {
	
	/**
	 * Parses the input. <b>This function must not throw and/or print exceptions/syntax errors</b> but return null instead.
	 * 
	 * @param s the String to parse
	 * @return the parsed input or null if the input is invalid for this parser.
	 */
	public T parse(String s);
	
	/**
	 * Returns a string representation of the given object. This is currenlty used for debugging.
	 * 
	 * @param o The object. This will never be <code>null</code>.
	 * @return The String representation of the object.
	 */
	public String toString(T o);
}
