/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import java.util.Iterator;

import org.bukkit.event.Event;

/**
 * @author Peter Gttinger
 * 
 *         this class extends Variable, thus it has its functions add(), set() and clear() which have event arguments. You usually don't need them, what you need is current().
 * 
 */
public abstract class LoopVar<T> extends Variable<T> implements Iterator<T> {
	
	/**
	 * @author Peter Gttinger
	 * 
	 */
	public static class LoopInfo<T> extends VariableInfo<T> {
		
		public String var;
		
		public LoopInfo(final Class<? extends LoopVar<T>> c, Class<T> returnType, final String var, final String[] patterns) {
			super(patterns, returnType, c);
			this.var = var;
		}
		
	}
	
	private Iterator<T> iter;
	private T current;
	
	protected abstract Iterator<T> iterator(final Event e);
	
	public final void startLoop(final Event e) {
		iter = iterator(e);
	}
	
	@Override
	public final boolean hasNext() {
		return iter.hasNext();
	}
	
	@Override
	public final T next() {
		return current = iter.next();
	}
	
	@Override
	public final void remove() {}
	
	@SuppressWarnings("unchecked")
	@Override
	protected final T[] getAll(final Event e) {
		return (T[]) new Object[] {current};
	}
	
	/**
	 * 
	 * @return the current value of the loop
	 */
	public final T current() {
		return current;
	}
	
}
