/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import java.util.ArrayList;

import org.bukkit.event.Event;

import ch.njol.skript.Trigger;

public class Loop extends TriggerItem {
	
	private Trigger trigger;
	
	private final LoopVar<?> var;
	private final ArrayList<TriggerItem> items;
	
	public static int level = 0;
	
	private boolean stopped = false;
	
	public <T> Loop(final LoopVar<T> var, final ArrayList<TriggerItem> items) {
		this.var = var;
		this.items = items;
	}
	
	@Override
	public boolean run(final Event e) {
		level++;
		var.startLoop(e);
		while (var.hasNext()) {
			var.next();
			for (final TriggerItem i : items) {
				if (!i.run(e)) {
					level--;
					return true;
				}
				if (stopped) {
					stopped = false;
					return true;
				}
			}
		}
		level--;
		return true;
	}
	
	public void setTrigger(final Trigger trigger) {
		this.trigger = trigger;
	}
	
	protected Trigger getTrigger() {
		return trigger;
	}
	
	public void stop() {
		stopped = true;
	}
}
