/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

/**
 * @author Peter Gttinger
 * 
 */
public class Literal<T> extends Variable<T> {
	
	private final T[] data;
	
	public Literal(final T[] data, final boolean and) {
		this.data = data;
		setAnd(and);
	}
	
	@SuppressWarnings("unchecked")
	public Literal(final T data) {
		this.data = (T[]) Array.newInstance(data.getClass(), 1);
		this.data[0] = data;
		and = true;
	}
	
	@Override
	public void set(final Event e, final Object[] to) {}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {}

	@Override
	public void init(List<Variable<?>> vars, int matchedPattern, Matcher matcher) {}

	@Override
	protected T[] getAll(final Event e) {
		return data;
	}

}
