/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import ch.njol.skript.Verbosity;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public interface Debuggable {
	/**
	 * This should return some debug information, e.g. the condition {@link CondBlock block} returns which block it checks & what the offset is:<br/>
	 * "block (offset: y,x,z): id:data*amount"<br/>
	 * <br/>
	 * Note: many classes in the util package implement Debuggable and/or the toString method.<br/>
	 * Usually toString is more verbose and prints out information for the end user.<br/>
	 * The block condition uses something like this:<br/>
	 * <code>return "block (offset: "+offset.getDebugMessage()+"): "+types.getDebugMessage();</code><br/>
	 * 
	 * @return a String printed on {@link Verbosity verbosity} very high or higher whenever this condition/effect is checked/executed.<br/>
	 *         for variables this should return %varname% or %varname(args,...)% respectively.
	 */
	public abstract String getDebugMessage();
}
