/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

/**
 * @author Peter Gttinger
 * 
 *         used to convert data types from a given type to the desired type.
 * 
 */
public interface Converter<F, T> {
	
	public static final class ConverterInfo<F, T> {
		
		public Class<F> from;
		public Class<T> to;
		public Converter<F, T> converter;
		
		public ConverterInfo(final Class<F> from, final Class<T> to, final Converter<F, T> converter) {
			this.from = from;
			this.to = to;
			this.converter = converter;
		}
		
	}
	
	public T convert(F f);
	
	public static final class ConverterUtils {
		
		@SuppressWarnings("unchecked")
		public final static <T, F> T convert(final ConverterInfo<F, T> i, final Object o) {
			if (i.from.isInstance(o))
				return i.converter.convert((F) o);
			return null;
		}
		
	}
	
}
