/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;

/**
 * @author Peter Gttinger
 * 
 */
public class ConvertedVariable<F, T> extends Variable<T> {
	
	private final Variable<?> var;
	private final Converter<? super F, ? extends T> converter;
	private final Class<T> to;
	
	private ConvertedVariable(final Variable<?> var, Converter<? super F, ? extends T> converter, final Class<T> to) {
		this.var = var;
		this.converter = converter;
		this.to = to;
	}

	public static <F, T> ConvertedVariable<F, T> newInstance(Variable<F> v, Class<T> to) {
		return newInstance(v, Skript.getVariableReturnType(v), to);
	}

	@SuppressWarnings("unchecked")
	public static <F, T> ConvertedVariable<F, T> newInstance(Variable<F> v, Class<? extends F> from, Class<T> to) {
		Converter<? super F, ? extends T> c = (Converter<? super F, ? extends T>) Skript.getConverter(from, to);
		if (c == null)
			return null;
		return new ConvertedVariable<F, T>(v, c, to);
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		var.init(vars, matchedPattern, matcher);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected T[] getAll(final Event e) {
		final Object[] fs = var.get(e);
		final T[] ts = (T[]) Array.newInstance(to, fs.length);
		for (int i = 0; i < fs.length; i++) {
			ts[i] = converter.convert((F) fs[i]);
		}
		return ts;
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		var.set(e, to);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		var.add(e, add);
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		var.remove(e, rem);
	}
	
	@Override
	public void clear(final Event e) {
		var.clear(e);
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}

}
