/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import org.bukkit.event.Event;

import ch.njol.util.Checker;

/**
 * 
 * a condition.
 * 
 * @author Peter Gttinger
 * 
 */
public abstract class Condition extends TopLevelExpression {
	
	private boolean invert = false;

	protected Condition() {}
	
	/**
	 * Checks whether this condition is satisfied with the given event. This should not alter the event or the world in any way, as conditions are only checked until one returns
	 * false. All subsequent conditions of the same trigger will then be omitted.<br/>
	 * <br/>
	 * You might want to use {@link Variable#check(Event, Checker)}
	 * 
	 * @param e the event to check
	 * @return <code>true</code> if the condition is satisfied, <code>false</code> otherwise or if the condition doesn't apply to this event.
	 */
	@Override
	public abstract boolean run(final Event e);

	protected final void setInverted(boolean invert) {
		this.invert = invert;
	}

	public final boolean getInverted() {
		return invert;
	}
	
}
