/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

/**
 * @author Peter Gttinger
 * 
 */
public interface Comparator<T1, T2> {
	
	/**
	 * a relation between two objects.
	 */
	public static enum Relation {
		EQUAL, GREATER, SMALLER, NOT_EQUAL;
		
		public static Relation get(final boolean b) {
			return b ? Relation.EQUAL : Relation.NOT_EQUAL;
		}
		
		public static Relation get(final int i) {
			return i == 0 ? Relation.EQUAL : i > 0 ? Relation.GREATER : Relation.SMALLER;
		}
		
		public static Relation get(final double d) {
			return d == 0 ? Relation.EQUAL : d > 0 ? Relation.GREATER : Relation.SMALLER;
		}
	}
	
	public static class ComparatorInfo<T1, T2> {
		
		public Class<T1> c1;
		public Class<T2> c2;
		public Comparator<T1, T2> c;
		
		public ComparatorInfo(final Class<T1> c1, final Class<T2> c2, final Comparator<T1, T2> c) {
			this.c1 = c1;
			this.c2 = c2;
			this.c = c;
		}
		
	}
	
	/**
	 * compares the given objects.
	 * 
	 * @param o1
	 * @param o2
	 * @return the relation of the obects. GREATER/SMALLER means the first object is greater/smaller. NOT_EQUAL is used for values which can't be compared by value.
	 */
	public Relation compare(T1 o1, T2 o2);
	
}
