/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

public final class ChainedConverter<F, M, T> implements Converter<F, T> {
	
	private final Converter<F, M> first;
	private final Converter<M, T> second;
	
	public ChainedConverter(final Converter<F, M> first, final Converter<M, T> second) {
		this.first = first;
		this.second = second;
	}
	
	@Override
	public T convert(final F f) {
		final M m = first.convert(f);
		if (m == null)
			return null;
		return second.convert(m);
	}
	
}
