/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.event.Event;

import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.TriggerItem;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class Trigger extends TriggerItem {
	public final String name;
	SkriptEvent event;
	List<TriggerItem> items = new ArrayList<TriggerItem>();
	private boolean stopped;
	
	Trigger(final String name, final SkriptEvent event, final List<TriggerItem> items) {
		this.name = name;
		this.event = event;
		this.items = items;
	}
	
	@Override
	public boolean run(final Event e) {
		if (Skript.log(Verbosity.VERY_HIGH))
			Skript.info("# " + name);
		if (!event.check(e))
			return false;
		for (final TriggerItem i : items) {
			// if (ok && Skript.log(Verbosity.VERY_HIGH))
			// Skript.info("   " + i.getDebugMessage());
			// if (!ok && Skript.log(Verbosity.VERY_HIGH))
			// Skript.info(" x " + i.getDebugMessage());
			if (!i.run(e))
				return false;
			if (stopped) {
				stopped = false;
				return false;
			}
		}
		return true;
	}
	
	public void stop() {
		stopped = true;
	}
}
