/*
 * Decompiled with CFR 0.152.
 */
package rublitio.uskaddon.utils;

import com.google.gson.stream.JsonWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import rublitio.uskaddon.utils.MessagePart;
import rublitio.uskaddon.utils.Reflection;
import rublitio.uskaddon.utils.TitleAPI;

public class JSONMessage {
    private final List<MessagePart> messageParts;
    private String jsonString;
    private boolean dirty;
    private Class<?> nmsTagCompound = Reflection.nmsClass("NBTTagCompound");
    private Class<?> nmsAchievement = Reflection.nmsClass("Achievement");
    private Class<?> nmsItemStack = Reflection.nmsClass("ItemStack");
    private Class<?> obcStatistic = Reflection.obcClass("CraftStatistic");
    private Class<?> obcItemStack = Reflection.obcClass("inventory.CraftItemStack");

    public JSONMessage(String firstPartText) {
        this.messageParts = new ArrayList<MessagePart>();
        this.messageParts.add(new MessagePart(firstPartText));
        this.jsonString = null;
        this.dirty = false;
    }

    public JSONMessage color(ChatColor color) {
        if (!color.isColor()) {
            throw new IllegalArgumentException(color.name() + " is not a color");
        }
        this.latest().color = color;
        this.dirty = true;
        return this;
    }

    public JSONMessage style(ChatColor[] styles) {
        ChatColor[] chatColorArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor style = chatColorArray[n2];
            if (!style.isFormat()) {
                throw new IllegalArgumentException(style.name() + " is not a style");
            }
            ++n2;
        }
        this.latest().styles = styles;
        this.dirty = true;
        return this;
    }

    public JSONMessage file(String path) {
        this.onClick("open_file", path);
        return this;
    }

    public JSONMessage link(String url) {
        this.onClick("open_url", url);
        return this;
    }

    public JSONMessage suggest(String command) {
        this.onClick("suggest_command", command);
        return this;
    }

    public JSONMessage command(String command) {
        this.onClick("run_command", command);
        return this;
    }

    public JSONMessage achievementTooltip(String name) {
        this.onHover("show_achievement", "achievement." + name);
        return this;
    }

    public JSONMessage achievementTooltip(Achievement which) {
        try {
            Object achievement = Reflection.getMethod(this.obcStatistic, "getNMSAchievement", new Class[0]).invoke(null, which);
            return this.achievementTooltip((String)Reflection.getField(this.nmsAchievement, "name").get(achievement));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public JSONMessage itemTooltip(String itemJSON) {
        this.onHover("show_item", itemJSON);
        return this;
    }

    public JSONMessage itemTooltip(ItemStack itemStack) {
        try {
            Object nmsItem = Reflection.getMethod(this.obcItemStack, "asNMSCopy", new Class[]{ItemStack.class}).invoke(null, itemStack);
            return this.itemTooltip(Reflection.getMethod(this.nmsItemStack, "save", new Class[0]).invoke(nmsItem, this.nmsTagCompound.newInstance()).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public JSONMessage tooltip(String[] lines) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            builder.append(lines[i]);
            if (i != lines.length - 1) {
                builder.append('\n');
            }
            ++i;
        }
        this.onHover("show_text", builder.toString());
        return this;
    }

    public JSONMessage then(Object obj) {
        this.messageParts.add(new MessagePart(obj.toString()));
        this.dirty = true;
        return this;
    }

    public String toJSONString() {
        if (!this.dirty && this.jsonString != null) {
            return this.jsonString;
        }
        StringWriter string = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)string);
        try {
            if (this.messageParts.size() == 1) {
                this.latest().writeJson(json);
            } else {
                json.beginObject().name("text").value("").name("extra").beginArray();
                for (MessagePart part : this.messageParts) {
                    part.writeJson(json);
                }
                json.endArray().endObject();
                json.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("invalid message");
        }
        this.jsonString = string.toString();
        this.dirty = false;
        return this.jsonString;
    }

    public void send(Player[] players) {
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        String nmsClass = String.valueOf(!version.startsWith("v1_7_R") ? "IChatBaseComponent$" : "") + "ChatSerializer";
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            try {
                Object packet = TitleAPI.getNMSClass("PacketPlayOutChat").getConstructor(TitleAPI.getNMSClass("IChatBaseComponent")).newInstance(TitleAPI.getNMSClass(nmsClass).getMethod("a", String.class).invoke(null, this.toJSONString()));
                Object handle = p.getClass().getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
                Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
                playerConnection.getClass().getMethod("sendPacket", TitleAPI.getNMSClass("Packet")).invoke(playerConnection, packet);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public String toOldMessageFormat() {
        StringBuilder result = new StringBuilder();
        for (MessagePart part : this.messageParts) {
            result.append(part.color).append(part.text);
        }
        return result.toString();
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private void onClick(String name, String data) {
        MessagePart latest = this.latest();
        latest.clickActionName = name;
        latest.clickActionData = data;
        this.dirty = true;
    }

    private void onHover(String name, String data) {
        MessagePart latest = this.latest();
        latest.hoverActionName = name;
        latest.hoverActionData = data;
        this.dirty = true;
    }
}

