/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="YAML Comments/header")
@Description(value={"Gets, sets, deletes comments or the header of a cached yaml file\n  - Headers don't contain '#' so add it yourself if you want it\n  - Comments can only be at root level ie. 'root' not 'root.something'\n  - Both comment and header expressions can be set to multiple elements\n  - This expression does not save to file\n  - Option to have an extra line or not depending if you use comment or header\n  - Any 'extra lines' are removed when deleting comments/headers"})
@Examples(value={"set the comments of yaml node \"test\" from \"config\" to \"First line\" and \"Second line\"", "delete the comments of yaml node \"test\" from \"config\"", " ", "set {_header::*} to \"First line\" and \"Second line\"", "set the comments at the top of \"config\" to {_header::*}", "delete the comments at the top of \"config\"", " ", "set the header of \"config\" to {_header::*}"})
@Since(value="1.1.0")
public class ExprYamlComments
extends SimpleExpression<Object> {
    private Expression<String> paths;
    private Expression<String> file;
    private int mark;
    private States state;

    static {
        Skript.registerExpression(ExprYamlComments.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] comment[s] (of|from) [y[a]ml] node[s] %strings% (of|in|from) %string% [(1\u00a6with [an] extra line)]", "[the] (comment[s] (at|on) [the] top of |header (of|from)) %string% [(1\u00a6with [an] extra line)]"});
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(@Nullable Event event, boolean b) {
        return String.valueOf(this.state.toString().toLowerCase()) + (this.state == States.COMMENT ? " for path " + this.paths.toString(event, b) : "") + " from yaml " + this.file.toString(event, b);
    }

    @Nullable
    protected Object[] get(Event event) {
        String name = StringUtil.checkSeparator((String)this.file.getSingle(event));
        String path = (String)this.paths.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return null;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        String s = null;
        if (this.state == States.COMMENT) {
            s = config.getComment(path);
        } else if (this.state == States.HEADER) {
            s = config.getHeader();
        }
        if (s == null) {
            return null;
        }
        List<String> list = Arrays.asList(s.split("\\r?\\n"));
        return list.toArray(new String[list.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String name = StringUtil.checkSeparator((String)this.file.getSingle(event));
        String[] paths = null;
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        if (this.state == States.COMMENT) {
            paths = (String[])this.paths.getAll(event);
            if (mode == Changer.ChangeMode.SET) {
                String[] comments = new String[delta.length];
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (!p.contains(".")) {
                        if (config.getMap().containsKey(p)) {
                            config.setComment(p, this.mark == 1, this.toStringArray(delta, comments));
                        } else {
                            SkriptYaml.warn("'" + p + "' is not a valid path in '" + name + "'");
                        }
                    } else {
                        SkriptYaml.warn("Comments can only be added to root paths not '" + p + "' in '" + name + "'");
                    }
                    ++n2;
                }
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                String[] stringArray = paths;
                int n = paths.length;
                int n3 = 0;
                while (n3 < n) {
                    String p = stringArray[n3];
                    if (config.getMap().containsKey(p)) {
                        String n4 = null;
                        config.setComment(p, false, n4);
                    }
                    ++n3;
                }
            }
        } else if (this.state == States.HEADER) {
            if (mode == Changer.ChangeMode.SET) {
                config.setHeader(this.toStringArray(delta, new String[delta.length]));
                config.setExtraHeaderLine(this.mark == 1);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                String n = null;
                config.setHeader(n);
                config.setExtraHeaderLine(false);
            }
        }
    }

    private String[] toStringArray(Object[] input, String[] output) {
        int i = 0;
        while (i < input.length) {
            output[i] = (String)input[i];
            ++i;
        }
        return output;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (matchedPattern == 0) {
            this.state = States.COMMENT;
            this.paths = e[0];
            this.file = e[1];
        } else {
            this.state = States.HEADER;
            this.file = e[0];
        }
        this.mark = parse.mark;
        return true;
    }

    private static enum States {
        COMMENT,
        HEADER;

    }
}

