/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="Save YAML")
@Description(value={"Saves the current cached YAML elements to file.\n\t - Using the `[with an indentation of %-number%]` option allows you to save the file with a different amount of spacing between 1 and 10\n\t - Option to remove extra lines between nodes"})
@Examples(value={"save yaml \"config\"", "save yaml \"config\" with an indentation of 2"})
@Since(value="1.0.0")
public class EffSaveYaml
extends Effect {
    private Expression<String> file;
    private Expression<Number> yamlIndent;
    private int mark;

    static {
        Skript.registerEffect(EffSaveYaml.class, (String[])new String[]{"save [y[a]ml] %strings% [with an indentation of %-number%] [(1\u00a6[and] with(out| no) extra lines between nodes)]"});
    }

    protected void execute(@Nullable Event event) {
        String[] stringArray = (String[])this.file.getAll(event);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (SkriptYaml.YAML_STORE.containsKey(name = StringUtil.checkSeparator(name))) {
                YAMLProcessor yaml = SkriptYaml.YAML_STORE.get(name);
                if (this.yamlIndent != null) {
                    yaml.setIndent(((Number)this.yamlIndent.getSingle(event)).intValue());
                }
                yaml.save(this.mark != 1);
            }
            ++n2;
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "save yaml " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.yamlIndent = exprs[1];
        this.mark = parse.mark;
        return true;
    }
}

