/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import org.bukkit.event.Event;

@Name(value="Does YAML Path Have List")
@Description(value={"Checks if one or more paths contain a list in a cached YAML file using said ID.\n  - First input is the path.\n  - Second input is the ID."})
@Examples(value={"if yaml node \"listnode\" from \"example\" has list:", "\tloop yaml list \"listnode\" from \"example\":", "\t\tbroadcast \"%loop-val%\""})
@Since(value="1.3")
public class CondNodeHasList
extends Condition {
    private Expression<String> path;
    private Expression<String> name;

    static {
        Skript.registerCondition(CondNodeHasList.class, (String[])new String[]{"[skript-]y[a]ml [(node|path)[s]] %string% (of|in|from) %string% has [a] list", "[skript-]y[a]ml [(node|path)[s]] %string% (of|in|from) %string% does(n't| not) have [a] list"});
    }

    public boolean check(final Event event) {
        return this.path.check(event, (Checker)new Checker<String>(){

            public boolean check(String s) {
                if (!SkriptYaml.YAML_STORE.containsKey(CondNodeHasList.this.name.getSingle(event))) {
                    return false;
                }
                Object o = SkriptYaml.YAML_STORE.get(CondNodeHasList.this.name.getSingle(event)).getProperty((String)CondNodeHasList.this.path.getSingle(event));
                return o != null ? o instanceof List : false;
            }
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "yaml path " + this.path.toString(event, debug) + " in " + this.name.toString(event, debug) + (this.isNegated() ? " is not a list  " : "is a list");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.path = exprs[0];
        this.name = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }
}

