/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="Load YAML")
@Description(value={"Loads a YAML file into memory.\n  - The first input is the YAML file path (ie. \"plugins/MyAwesomePlugin/config.yml\").\n  - The second input allows you to choose your own ID for this file.\n  - If the second input isn't used then the files name minus the extention is used as the ID for example `config.yml` becomes `config`."})
@Examples(value={"#Both examples produce the same id for use in other effects/expressions", "load yaml \"plugins/MyAwesomePlugin/config.yml\"", "load yaml \"plugins/MyAwesomePlugin/config.yml\" as \"config\"", " ", "#to get similar function as the other addons you would do this sort of thing with the id...", "\tload yaml \"plugins/MyAwesomePlugin/config.yml\" as file path", "\tset yaml value \"version\" from \"plugins/MyAwesomePlugin/config.yml\" to 1.0", "\tbroadcast \"%yaml value \"\"version\"\" from \"\"plugins/MyAwesomePlugin/config.yml\"\"%\""})
@Since(value="1.0.0")
public class EffLoadYaml
extends Effect {
    private Expression<String> file;
    private Expression<String> id;
    private int mark;
    private int matchedPattern;

    static {
        Skript.registerEffect(EffLoadYaml.class, (String[])new String[]{"[re]load [(1\u00a6non[(-| )]relative)] [y[a]ml] %strings%", "[re]load [(1\u00a6non[(-| )]relative)] [y[a]ml] %string% as %string%", "[re]load [(1\u00a6non[(-| )]relative)] [y[a]ml] %strings% using [the] [file] path[s] as [the] id[s]"});
    }

    protected void execute(@Nullable Event event) {
        if (this.matchedPattern == 1) {
            if (!this.file.isSingle()) {
                SkriptYaml.warn("[Load Yaml] Input has to be single if using a custom id");
                return;
            }
            this.load((String)this.file.getSingle(event), event);
        } else {
            String[] stringArray = (String[])this.file.getAll(event);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.load(name, event);
                ++n2;
            }
        }
    }

    private void load(String name, Event event) {
        File yamlFile = null;
        String server = String.valueOf(new File("").getAbsoluteFile().getAbsolutePath()) + File.separator;
        yamlFile = this.mark == 1 ? new File(StringUtil.checkRoot(StringUtil.checkSeparator(name))) : new File(String.valueOf(server) + StringUtil.checkSeparator(name));
        try {
            if (!yamlFile.exists()) {
                String filePath = yamlFile.getPath();
                int index = filePath.lastIndexOf(File.separator);
                File folder = new File(filePath.substring(0, index));
                if (index >= 0 && !folder.exists()) {
                    folder.mkdirs();
                }
                yamlFile.createNewFile();
            }
        }
        catch (IOException error) {
            SkriptYaml.error("[Load Yaml] " + error.getMessage() + " (" + name + ")");
            return;
        }
        YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
        try {
            try {
                yaml.load();
            }
            catch (IOException e) {
                e.printStackTrace();
                String n = null;
                if (this.matchedPattern == 0) {
                    n = StringUtil.stripExtention(yamlFile.getName());
                } else if (this.matchedPattern == 1) {
                    n = (String)this.id.getSingle(event);
                } else if (this.matchedPattern == 2) {
                    n = name;
                }
                SkriptYaml.YAML_STORE.put(n, yaml);
            }
        }
        finally {
            String n = null;
            if (this.matchedPattern == 0) {
                n = StringUtil.stripExtention(yamlFile.getName());
            } else if (this.matchedPattern == 1) {
                n = (String)this.id.getSingle(event);
            } else if (this.matchedPattern == 2) {
                n = name;
            }
            SkriptYaml.YAML_STORE.put(n, yaml);
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load yaml" + (this.mark == 1 ? " non-relative " : " ") + this.file.toString(event, b) + (this.id != null ? " as " + this.id.toString(event, b) : (this.matchedPattern == 2 ? " using the file path as the id" : ""));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        if (matchedPattern == 1) {
            this.id = exprs[1];
        }
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        return true;
    }
}

