/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.AsyncEffectOld;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.SkriptYamlUtils;
import me.sashie.skriptyaml.utils.StringUtil;
import org.bukkit.event.Event;

@Name(value="Delete all YAML from one or more directories")
@Description(value={"Syntax 1: Deletes all YAML files from one or more directories and removes them from memory.\nSyntax 2&3: Only deletes any loaded YAML files from one or more directories and removes them from memory.\n  - The input is one or more directories (ie. \"plugins/MyAwesomePlugin/\" and \"plugins/skript-yaml/\")."})
@Examples(value={"delete all yaml from directory \"/plugins/skript-yaml/test\"", " ", "delete all loaded yaml from directory \"/plugins/skript-yaml/test\"", " ", "delete all loaded yaml from directory \"/plugins/skript-yaml/test\" using the filename as the id"})
@Since(value="1.2.1")
public class EffDeleteYamlFromDirectory
extends AsyncEffectOld {
    private Expression<String> directories;
    private int mark;
    private int matchedPattern;

    static {
        Skript.registerEffect(EffDeleteYamlFromDirectory.class, (String[])new String[]{"delete (all|any) [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%", "delete (all|any) loaded [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%", "delete (all|any) loaded [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }

    protected void execute(@Nullable Event event) {
        String[] stringArray = (String[])this.directories.getAll(event);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File[] fileArray = SkriptYamlUtils.directoryFilter(StringUtil.checkSeparator(name), this.mark == 1, "Delete");
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File yamlFile = fileArray[n4];
                if (this.matchedPattern == 0) {
                    yamlFile.delete();
                } else {
                    String n5 = null;
                    if (this.matchedPattern == 1) {
                        n5 = String.valueOf(StringUtil.checkLastSeparator(name)) + yamlFile.getName();
                    } else if (this.matchedPattern == 2) {
                        n5 = StringUtil.stripExtention(yamlFile.getName());
                    }
                    if (SkriptYaml.YAML_STORE.containsKey(n5)) {
                        SkriptYaml.YAML_STORE.get(n5).getFile().delete();
                        SkriptYaml.YAML_STORE.remove(n5);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "delete all" + (this.matchedPattern == 0 ? " loaded " : " ") + "yaml from" + (this.mark == 1 ? " non-relative " : " ") + "director" + (this.directories.isSingle() ? "y " : "ies ") + this.directories.toString(event, b) + (this.matchedPattern == 2 ? " using the filename as the id" : "");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.directories = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        return true;
    }
}

