/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.ParameterizedType;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;

public class SkriptYamlUtils {
    public static File[] directoryFilter(String name, boolean root, String errorPrefix) {
        File dir = null;
        if (root) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            String server = new File("").getAbsoluteFile().getAbsolutePath();
            dir = new File(String.valueOf(server) + File.separator + name);
        }
        if (!dir.isDirectory()) {
            SkriptYaml.warn("[" + errorPrefix + " Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    public static <T> Class<T> getType(Class<T> c) {
        return (Class)((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

