/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="Unload YAML")
@Description(value={"Unloads one or more YAML files or directories full of YAML files from memory."})
@Examples(value={"unload yaml \"config\"", " ", "unload yaml directory \"plugins\\skript-yaml\""})
@Since(value="1.0.0")
public class EffUnloadYaml
extends Effect {
    private Expression<String> file;
    private int mark;

    static {
        Skript.registerEffect(EffUnloadYaml.class, (String[])new String[]{"unload [y[a]ml] [(1\u00a6director(y|ies))] %strings%"});
    }

    protected void execute(@Nullable Event event) {
        String server = null;
        if (this.mark == 1) {
            server = String.valueOf(new File("").getAbsoluteFile().getAbsolutePath()) + File.separator;
        }
        String[] stringArray = (String[])this.file.getAll(event);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.mark == 1) {
                Iterator<Map.Entry<String, YAMLProcessor>> it = SkriptYaml.YAML_STORE.entrySet().iterator();
                while (it.hasNext()) {
                    String path = it.next().getValue().getParentPath();
                    if (!path.equals(String.valueOf(server) + StringUtil.removeFirst(server, name))) continue;
                    it.remove();
                }
            } else if (SkriptYaml.YAML_STORE.containsKey(name)) {
                SkriptYaml.YAML_STORE.remove(name);
            }
            ++n2;
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "unload yaml" + (this.mark == 1 ? "director(y|ies) " : " ") + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.file = exprs[0];
        this.mark = parser.mark;
        return true;
    }
}

