/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import org.bukkit.event.Event;

@Name(value="Is YAML Loaded")
@Description(value={"Checks if one or more YAML files are loaded into memory using said ID."})
@Examples(value={"yaml \"config\" is loaded:", " ", "yaml \"config\" and \"messages\" aren't loaded:"})
@Since(value="1.0.3")
public class CondYamlIsLoaded
extends Condition {
    private Expression<String> file;

    static {
        Skript.registerCondition(CondYamlIsLoaded.class, (String[])new String[]{"y[a]ml[s] %strings% (is|are) loaded", "y[a]ml[s] %strings% ((are|is) not|(is|are)n[']t) loaded"});
    }

    public boolean check(final Event event) {
        return this.file.check(event, (Checker)new Checker<String>(){

            public boolean check(String s) {
                return SkriptYaml.YAML_STORE.containsKey(CondYamlIsLoaded.this.file.getSingle(event));
            }
        }, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "yaml " + this.file.toString(e, debug) + (this.file.isSingle() ? " is " : " are ") + (this.isNegated() ? "not loaded" : "loaded");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }
}

