/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import me.sashie.skriptyaml.Metrics;
import me.sashie.skriptyaml.api.ConstructedClass;
import me.sashie.skriptyaml.api.RepresentedClass;
import me.sashie.skriptyaml.utils.SkriptYamlUtils;
import me.sashie.skriptyaml.utils.yaml.SkriptYamlConstructor;
import me.sashie.skriptyaml.utils.yaml.SkriptYamlRepresenter;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptYaml
extends JavaPlugin {
    public static final Logger LOGGER = Bukkit.getServer() != null ? Bukkit.getLogger() : Logger.getLogger("global");
    public static final HashMap<String, YAMLProcessor> YAML_STORE = new HashMap();
    private static SkriptYaml instance;
    private int serverVersion;
    private static final HashMap<String, String> REGISTERED_TAGS;
    private static SkriptYamlRepresenter representer;
    private static SkriptYamlConstructor constructor;

    static {
        REGISTERED_TAGS = new HashMap();
    }

    public SkriptYaml() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public static boolean isTagRegistered(String tag) {
        return REGISTERED_TAGS.containsKey(tag);
    }

    public static void registerTag(JavaPlugin plugin, String tag, Class<?> c, RepresentedClass<?> rc, ConstructedClass<?> cc) {
        String prefix = String.valueOf(plugin.getName().toLowerCase()) + "-";
        if (!tag.startsWith(prefix)) {
            tag = String.valueOf(prefix) + tag;
        }
        if (!REGISTERED_TAGS.containsKey(tag)) {
            if (!representer.contains(c)) {
                if (SkriptYamlUtils.getType(rc.getClass()) == c) {
                    if (SkriptYamlUtils.getType(((Object)cc).getClass()) == c) {
                        REGISTERED_TAGS.put(tag, plugin.getName());
                        representer.register(tag, c, rc);
                        constructor.register(tag, cc);
                    } else {
                        SkriptYaml.warn("The class '" + c.getSimpleName() + "' that the plugin '" + plugin.getName() + "' is trying to register does not match constructed class '" + SkriptYamlUtils.getType(((Object)cc).getClass()).getSimpleName() + "' for constructor '" + ((Object)cc).getClass().getSimpleName() + "' the tag '" + tag + "' was not registered");
                    }
                } else {
                    SkriptYaml.warn("The class '" + c.getSimpleName() + "' that the plugin '" + plugin.getName() + "' is trying to register does not match represented class '" + SkriptYamlUtils.getType(rc.getClass()).getSimpleName() + "' for representer '" + rc.getClass().getSimpleName() + "' the tag '" + tag + "' was not registered");
                }
            } else {
                SkriptYaml.warn("The class '" + c.getSimpleName() + "' that the plugin '" + plugin.getName() + "' is trying to register for the tag '" + tag + "' is already registered");
            }
        } else {
            SkriptYaml.warn("The plugin '" + plugin.getName() + "' is trying to register the tag '" + tag + "' but it's already registered to '" + REGISTERED_TAGS.get(tag) + "'");
        }
    }

    public void onEnable() {
        String initServerVer = Bukkit.getServer().getClass().getPackage().getName().substring(23);
        this.serverVersion = Integer.parseInt(Character.toString(initServerVer.charAt(3)));
        if (this.serverVersion == 1 && Integer.parseInt(Character.toString(initServerVer.charAt(4))) >= 0) {
            this.serverVersion = Integer.parseInt(String.valueOf(Integer.parseInt(Character.toString(initServerVer.charAt(3)))) + Integer.parseInt(Character.toString(initServerVer.charAt(4))));
        }
        representer = new SkriptYamlRepresenter();
        constructor = new SkriptYamlConstructor();
        Plugin skript = Bukkit.getServer().getPluginManager().getPlugin("Skript");
        if (skript != null) {
            if (Skript.isAcceptRegistrations()) {
                try {
                    SkriptAddon addonInstance = Skript.registerAddon((JavaPlugin)this);
                    addonInstance.loadClasses("me.sashie.skriptyaml", new String[]{"skript"});
                }
                catch (SkriptAPIException e) {
                    SkriptYaml.error("Somehow you loaded skript-yaml after Skript has already finished registering addons, which Skript does not allow! Did you load this using a plugin manager?");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Metrics metrics = new Metrics((Plugin)this);
            metrics.addCustomChart(new Metrics.DrilldownPie("plugin_tags", new Callable<Map<String, Map<String, Integer>>>(){

                @Override
                public Map<String, Map<String, Integer>> call() throws Exception {
                    return SkriptYaml.this.registeredTags();
                }
            }));
        } else {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            SkriptYaml.error("Skript not found, plugin disabled.");
        }
    }

    private Map<String, Map<String, Integer>> registeredTags() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        for (String tag : REGISTERED_TAGS.keySet()) {
            String pluginName = REGISTERED_TAGS.get(tag);
            Map entry = !map.containsKey(pluginName) ? new HashMap() : (Map)map.get(pluginName);
            entry.put(tag, 1);
            map.put(pluginName, entry);
        }
        return map;
    }

    public static SkriptYaml getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public SkriptYamlRepresenter getRepresenter() {
        return representer;
    }

    public SkriptYamlConstructor getConstructor() {
        return constructor;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public static void warn(String error) {
        LOGGER.warning("[skript-yaml] " + error);
    }

    public static void error(String error) {
        LOGGER.severe("[skript-yaml] " + error);
    }
}

