/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="All YAML Nodes")
@Description(value={"Gets a list of all nodes of a cached YAML file."})
@Examples(value={"set yaml value \"test1.test2\" from \"config\" to \"test3\"", "set yaml value \"boop.beep\" from \"config\" to \"bop\"", " ", "set {_list::*} to all yaml nodes of \"config\"", "broadcast \"%{_list::*}%\""})
@Since(value="1.0.4")
public class ExprAllYamlNodes
extends SimpleExpression<String> {
    private Expression<String> file;

    static {
        Skript.registerExpression(ExprAllYamlNodes.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] [[skript-]y[a]ml] (node|path)[s] (of|in|from) %string%"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "all yaml nodes from " + this.file.toString(event, b);
    }

    @Nullable
    protected String[] get(Event event) {
        String name = (String)this.file.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            return null;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        List<String> nodes = config.getAllKeys();
        if (nodes != null) {
            return nodes.toArray(new String[nodes.size()]);
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        return true;
    }
}

