/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SimpleExpressionFork;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLNode;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

@Name(value="YAML")
@Description(value={"Gets, sets, removes values/nodes etc.. of a cached yaml file\n  - Requires the id used/created from the load effect\n  - This expression does not save to file\n  - Lists accept list variables for input\n  - Using 'without string checks' optional is a tiny bit faster but doesn't check/convert strings for numbers or booleans"})
@Examples(value={"set yaml value \"test1.test2\" from \"config\" to \"test3\"", "set yaml list \"list.name\" from \"config\" to {_list::*}", " ", "set {_test} to yaml value \"test1.test2\" from \"config\"", "broadcast \"%{_test}%\""})
@Since(value="1.0.0")
public class ExprYaml<T>
extends SimpleExpressionFork<T> {
    private boolean checks = false;
    private Expression<String> node;
    private Expression<String> file;
    private States state;
    private final ExprYaml<?> source;
    private final Class<T> superType;

    static {
        Skript.registerExpression(ExprYaml.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[[skript-]y[a]ml] (1\u00a6value|2\u00a6(node|path) list|3\u00a6(node|path)[s with] keys|4\u00a6list) %string% (of|in|from) %string% [without string checks]"});
    }

    public ExprYaml() {
        this(null, Object.class);
    }

    private ExprYaml(ExprYaml<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.node = source.node;
            this.file = source.file;
            this.state = source.state;
            this.checks = source.checks;
        }
        this.superType = Utils.getSuperType((Class[])types);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprYaml<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Class<? extends T> getReturnType() {
        if (this.state == States.NODES) {
            return String.class;
        }
        return this.superType;
    }

    public boolean isSingle() {
        return this.state == States.VALUE;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "yaml " + this.state.toString().toLowerCase() + " " + this.node.toString(event, b) + " from " + this.file.toString(event, b) + (!this.checks ? "" : " without string checks");
    }

    @Override
    @Nullable
    protected T[] get(Event event) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.node.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return null;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        if (this.state == States.VALUE) {
            Object o = config.getProperty(path);
            if (o != null) {
                if (!this.checks && String.class.isAssignableFrom(o.getClass())) {
                    o = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)o));
                }
                try {
                    return ExprYaml.convertToArray(o, o.getClass());
                }
                catch (ClassCastException e) {
                    return (Object[])Array.newInstance(o.getClass(), 0);
                }
            }
            return null;
        }
        if (this.state == States.NODES) {
            if (path.equals("")) {
                Set<String> rootNodes = config.getMap().keySet();
                return ExprYaml.lazyConvert(rootNodes.toArray(new String[rootNodes.size()]));
            }
            YAMLNode node = config.getNode(path);
            if (node == null) {
                return null;
            }
            Map<String, Object> nodes = node.getMap();
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : nodes.keySet()) {
                keys.add(String.valueOf(path) + "." + key);
            }
            return ExprYaml.lazyConvert(keys.toArray(new String[keys.size()]));
        }
        if (this.state == States.NODES_KEYS) {
            List<String> nodesKeys = config.getKeys(path);
            if (nodesKeys == null) {
                return null;
            }
            return ExprYaml.lazyConvert(nodesKeys.toArray(new String[nodesKeys.size()]));
        }
        if (this.state == States.LIST) {
            List<Object> items = config.getList(path);
            if (items == null) {
                return null;
            }
            try {
                return ExprYaml.convertArray(items.toArray(), this.superType);
            }
            catch (ClassCastException e) {
                return (Object[])Array.newInstance(this.superType, 0);
            }
        }
        return null;
    }

    public static final <T> T[] lazyConvert(Object[] original) {
        try {
            return ExprYaml.convertArray(original, String.class);
        }
        catch (ClassCastException e) {
            return (Object[])Array.newInstance(String.class, 0);
        }
    }

    public static final <T> T[] convertToArray(Object original, Class<T> to) throws ClassCastException {
        Object[] end = (Object[])Array.newInstance(to, 1);
        Object converted = Converters.convert((Object)original, to);
        if (converted == null) {
            throw new ClassCastException();
        }
        end[0] = converted;
        return end;
    }

    public static final <T> T[] convertArray(Object[] original, Class<T> to) throws ClassCastException {
        Object[] end = (Object[])Array.newInstance(to, original.length);
        int i = 0;
        while (i < original.length) {
            Object converted = Converters.convert((Object)original[i], to);
            if (converted == null) {
                throw new ClassCastException();
            }
            end[i] = converted;
            ++i;
        }
        return end;
    }

    @Override
    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.node.getSingle(event);
        if (!SkriptYaml.YAML_STORE.containsKey(name)) {
            SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded");
            return;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            config.removeProperty(path);
            return;
        }
        if (this.state == States.VALUE) {
            if (mode == Changer.ChangeMode.SET) {
                config.setProperty(path, this.parseString(delta[0]));
            }
        } else if (this.state == States.NODES_KEYS) {
            if (mode == Changer.ChangeMode.ADD) {
                config.addNode(path);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                config.setProperty(String.valueOf(path) + (delta[0] == null ? "" : "." + delta[0]), null);
            }
        } else if (this.state == States.LIST) {
            List<Object> objects = config.getList(path);
            if (mode == Changer.ChangeMode.ADD) {
                if (objects == null) {
                    config.setProperty(path, this.arrayToList(new LinkedList<Object>(), delta));
                } else {
                    config.setProperty(path, this.arrayToList(objects, delta));
                }
            } else if (mode == Changer.ChangeMode.REMOVE) {
                Object[] objectArray = delta;
                int n = delta.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    objects.remove(this.parseString(o));
                    ++n2;
                }
            } else if (mode == Changer.ChangeMode.SET) {
                if (objects == null) {
                    config.setProperty(path, this.arrayToList(new LinkedList<Object>(), delta));
                } else {
                    objects.clear();
                    config.setProperty(path, this.arrayToList(objects, delta));
                }
            }
        }
    }

    private List<Object> arrayToList(List<Object> list, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            list.add(this.parseString(o));
            ++n2;
        }
        return list;
    }

    private Object parseString(Object delta) {
        if (!this.checks && String.class.isAssignableFrom(delta.getClass())) {
            String s = StringUtil.translateColorCodes((String)delta);
            if (s.matches("true|false|yes|no|on|off")) {
                return s.matches("true|yes|on");
            }
            if (s.matches("(-)?\\d+")) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else {
                if (s.matches("(-)?\\d+(\\.\\d+)")) {
                    return Double.parseDouble(s);
                }
                return s;
            }
        }
        return delta;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        if (this.state == States.VALUE) {
            if (mode == Changer.ChangeMode.SET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
            }
        } else if (this.state == States.LIST && (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (parse.mark == 1) {
            this.state = States.VALUE;
        } else if (parse.mark == 2) {
            this.state = States.NODES;
        } else if (parse.mark == 3) {
            this.state = States.NODES_KEYS;
        } else if (parse.mark == 4) {
            this.state = States.LIST;
        }
        this.node = e[0];
        this.file = e[1];
        if (parse.expr.toLowerCase().endsWith(" without string checks")) {
            this.checks = true;
        }
        return true;
    }

    private static enum States {
        VALUE,
        NODES,
        NODES_KEYS,
        LIST;

    }
}

